<?php

class RTDelivery
{

    public static function extractFinalRentalStartEndDate($rental_start_date, $rental_end_date, $opt_hide_time_pickers, $opt_default_start_time, $opt_default_end_time, $opt_hide_end_date) {
        // Set default start time if time picker is hidden on calendar
        if ($rental_start_date && $opt_hide_time_pickers) {
            $start_date_exploded = explode(" ", $rental_start_date);

            if (isset($start_date_exploded[0]) && $start_date_exploded[0]) {
                $rental_start_date = $start_date_exploded[0] . ' ' . $opt_default_start_time;
            }
        }

        // Set default end time if time picker or end date is hidden on calendar
        if (
            !$rental_end_date &&
            ($opt_hide_time_pickers 
            || $opt_hide_end_date)
        ) {
            $start_date_exploded = explode(" ", $rental_start_date);

            if (isset($start_date_exploded[0]) && $start_date_exploded[0]) {
                $rental_end_date = $start_date_exploded[0] . ' ' . $opt_default_end_time;
            }
        }
        
        if (
            $rental_end_date &&
            ($opt_hide_time_pickers 
            || $opt_hide_end_date)
        ) {
            $end_date_exploded = explode(" ", $rental_end_date);

            if (isset($end_date_exploded[0]) && $end_date_exploded[0]) {
                $rental_end_date = $end_date_exploded[0] . ' ' . $opt_default_end_time;
            }
        }

        return [
            'rental_start_date' => $rental_start_date,
            'rental_end_date' => $rental_end_date,
        ];
    }
    

    public static function extractDeliveryStartEndTime($rental_start_date, $timezone, $rental_selected_delivery_selection_time_cookie)
    {

        $startDateTime = $endDateTime = '';
        $rental_selected_delivery_selection_time = json_decode(stripslashes($rental_selected_delivery_selection_time_cookie), 1);

        $arrival_start_time = isset($rental_selected_delivery_selection_time['start_time']) && $rental_selected_delivery_selection_time['start_time'] ? $rental_selected_delivery_selection_time['start_time'] : '';
        $arrival_end_time = isset($rental_selected_delivery_selection_time['end_time']) && $rental_selected_delivery_selection_time['end_time'] ? $rental_selected_delivery_selection_time['end_time'] : '';

        if ($arrival_start_time) {
            $start_date_only = date('Y/m/d', strtotime($rental_start_date));
            $combined_start_date_delivery_time = $start_date_only . ' ' . $arrival_start_time;
            $startDateTime = DateTime::createFromFormat('Y/m/d h:i A', $combined_start_date_delivery_time, $timezone);
            $startDateTime = $startDateTime->getTimestamp();
        }

        if ($arrival_end_time) {
            $start_date_only = date('Y/m/d', strtotime($rental_start_date));
            $combined_end_date_delivery_time = $start_date_only . ' ' . $arrival_end_time;
            $endDateTime = DateTime::createFromFormat('Y/m/d h:i A', $combined_end_date_delivery_time, $timezone);
            $endDateTime = $endDateTime->getTimestamp();
        }

        return [
            'start_time' => $startDateTime,
            'end_time' => $endDateTime,
        ];
    }


    public static function extractPickupStartEndTime($rental_end_date, $timezone, $rental_selected_pickup_selection_time_cookie)
    {
        $pickupStartDateTime = $pickupEndDateTime = '';
        $rental_selected_pickup_selection_time = json_decode(stripslashes($rental_selected_pickup_selection_time_cookie), 1);

        $pickup_start_time = isset($rental_selected_pickup_selection_time['start_time']) && $rental_selected_pickup_selection_time['start_time'] ? $rental_selected_pickup_selection_time['start_time'] : '';
        $pickup_end_time = isset($rental_selected_pickup_selection_time['end_time']) && $rental_selected_pickup_selection_time['end_time'] ? $rental_selected_pickup_selection_time['end_time'] : '';

        if ($pickup_start_time) {
            $end_date_only = date('Y/m/d', strtotime($rental_end_date));
            $combined_end_date_delivery_time = $end_date_only . ' ' . $pickup_start_time;
            $pickupStartDateTime = DateTime::createFromFormat('Y/m/d h:i A', $combined_end_date_delivery_time, $timezone);
            $pickupStartDateTime = $pickupStartDateTime->getTimestamp();
        }

        if ($pickup_end_time) {
            $end_date_only = date('Y/m/d', strtotime($rental_end_date));
            $combined_end_date_delivery_time = $end_date_only . ' ' . $pickup_end_time;
            $pickupEndDateTime = DateTime::createFromFormat('Y/m/d h:i A', $combined_end_date_delivery_time, $timezone);
            $pickupEndDateTime = $pickupEndDateTime->getTimestamp();
        }

        return [
            'start_time' => $pickupStartDateTime,
            'end_time' => $pickupEndDateTime,
        ];
    }

}