<?php

require_once('RTAttribute.php');
require_once('RTImage.php');

class RTAttributeValue
{
    /**
     * Expected fields from Rentopian.
     */
    public $attribute_rental_id,
        $slug,
        $title,
        $color,
        $img_id,
        $old_slug;

    /**
     * Create a new instance.
     *
     * @param int $attribute_rental_id
     * @param string $slug
     * @param string $title
     * @param string $color
     * @param int $img_id
     * @param string $old_slug
     */
    public function __construct($attribute_rental_id, $slug, $title, $color, $img_id, $old_slug)
    {
        $this->attribute_rental_id = $attribute_rental_id;
        $this->slug = $slug;
        $this->title = $title;
        $this->color = $color;
        $this->img_id = $img_id;
        $this->old_slug = $old_slug;
    }

    /**
     * Get product attribute value by slug and taxonomy.
     *
     * @param string $slug
     * @param string $taxonomy
     * @return object|null
     */
    public function getAttributeValue($slug, $taxonomy)
    {
        global $wpdb;

        return $wpdb->get_row("SELECT `$wpdb->terms`.`slug`, `$wpdb->terms`.`name`, `tt`.`term_taxonomy_id`, `tt`.`term_id` FROM `$wpdb->terms` " .
            "INNER JOIN `$wpdb->term_taxonomy` AS `tt` ON `tt`.`term_id` = `$wpdb->terms`.`term_id` " .
            "WHERE `$wpdb->terms`.`slug` = '$slug' AND `tt`.`taxonomy` = 'pa_$taxonomy'");
    }

    /**
     * Set meta field to attribute value depending on the attribute swatch_type.
     *
     * @param int $attribute_id
     * @param string $attribute_name
     * @param int $term_id
     * @return void
     */
    private function setMetaDependingOnAttributeType($attribute_id, $attribute_name, $term_id, $color = '', $img_id = 0) {
        global $wpdb;

        if (defined('ZOO_CW_VERSION')) {
            $attribute_type = $wpdb->get_var("SELECT `swatch_type` FROM `" . $wpdb->prefix . "zoo_cw_product_attribute_swatch_type` " .
            "WHERE `attribute_id` = $attribute_id");

            if ($attribute_type == "color") {
                update_term_meta($term_id, "slctd_clr", $this->color?: "");

            } elseif ($attribute_type == "image") {
                $image = "";
                if ($this->img_id) {
                    $images = (new RTImage())->getImages([$this->img_id]);
                    if (isset($images[$this->img_id])) {
                        $image = wp_get_attachment_image_url($images[$this->img_id]);
                    }
                }
                update_term_meta($term_id, "slctd_img", $image);
            }
        }

        if (defined('RENTPRO_SWATCHES_PATH')) {
            if ($color) {
                update_term_meta($term_id, "sw_color", $color?: "");
                update_term_meta($term_id, "sw_tooltip", $this->title?: "");

            } else if ($img_id) {
                $image = "";
                if ($img_id) {
                    update_term_meta($term_id, "sw_image", $img_id);
                }
                update_term_meta($term_id, "sw_tooltip", $this->title?: "");

            }
        }

        if (defined('WOOF_PATH')) {
            $attribute_name = "pa_$attribute_name";
            $woof_settings = get_option('woof_settings');
            if (empty($woof_settings) || !isset($woof_settings["tax_type"]) || !isset($woof_settings["tax_type"][$attribute_name])) {
                return;
            }
            $attribute_type = $woof_settings["tax_type"][$attribute_name];
            if ($attribute_type == "color") {
                if ( !isset($woof_settings["color"])) {
                    $woof_settings["color"] = [$attribute_name => []];
                } elseif ( !isset($woof_settings["color"][$attribute_name])) {
                    $woof_settings["color"][$attribute_name] = [];
                }
                $woof_settings["color"][$attribute_name][$this->slug] = $this->color?: "#000000";
                update_option("woof_settings", $woof_settings);
            } elseif ($attribute_type == "image") {
                if ( !isset($image)) {
                    $image = "";
                    if ($this->img_id) {
                        $images = (new RTImage())->getImages([$this->img_id]);
                        if (isset($images[$this->img_id])) {
                            $image = wp_get_attachment_image_url($images[$this->img_id]);
                        }
                    }
                }
                if ( !isset($woof_settings["images_term_$term_id"])) {
                    $woof_settings["images_term_$term_id"] = [];
                }
                $woof_settings["images_term_$term_id"]["image_url"] = $image;
                update_option("woof_settings", $woof_settings);
            }
        }
    }

    /**
     * Change attribute value slug everywhere
     *
     * @param string $attribute_name
     * @param string $new_slug
     * @param string $old_slug
     * @return void
     */
    private function changeAttributeValueSlug($attribute_name, $new_slug, $old_slug)
    {
        global $wpdb;

        // update `meta_key` id `postmeta` table
        $wpdb->update($wpdb->postmeta, [
            "meta_value" => $new_slug
        ], [
            "meta_key" => "attribute_pa_$attribute_name",
            "meta_value" => $old_slug
        ]);
    }

    /**
     * Create product attribute value.
     *
     * @param object $attribute
     * @return object
     */
    public function create($attribute)
    {
        register_taxonomy("pa_$attribute->attribute_name", "product");
        $term = wp_insert_term($this->title, "pa_$attribute->attribute_name", ["slug" => $this->slug]);

        $this->setMetaDependingOnAttributeType($attribute->attribute_id, $attribute->attribute_name, $term["term_id"], $this->color, $this->img_id);

        $term["slug"] = $this->slug;
        $term["name"] = $this->title;
        return (object) $term;
    }

    /**
     * Update product attribute value.
     *
     * @param object $attribute
     * @param object $attribute_value
     * @return object
     */
    public function update($attribute, $attribute_value)
    {
        global $wpdb;

        $update = $wpdb->update($wpdb->terms, [
            "slug" => $this->slug,
            "name" => $this->title,
        ], [
            "term_id" => $attribute_value->term_id
        ]);
        if ($update) {
            if ($attribute_value->slug != $this->slug) {
                $this->changeAttributeValueSlug($attribute->attribute_name, $this->slug, $attribute_value->slug);
                $attribute_value->slug = $this->slug;
            }
            $attribute_value->name = $this->title;
        }
        $this->setMetaDependingOnAttributeType($attribute->attribute_id, $attribute->attribute_name, $attribute_value->term_id, $this->color, $this->img_id);

        return $attribute_value;
    }

    /**
     * Create or update product attribute value.
     *
     * @return object|false
     */
    public function save()
    {
        $attribute = (new RTAttribute($this->attribute_rental_id))->getAttribute();
        if ( !$attribute) {
            return false;
        }

        if ($this->old_slug && $this->old_slug != $this->slug) {
            $attribute_value = $this->getAttributeValue($this->old_slug, $attribute->attribute_name);
        } else {
            $attribute_value = $this->getAttributeValue($this->slug, $attribute->attribute_name);
        }

        if ($attribute_value) {
            return $this->update($attribute, $attribute_value);
        }
        return $this->create($attribute);
    }

    /**
     * Delete product attribute value.
     *
     * @return object|false
     */
    public function delete()
    {
        $attribute = (new RTAttribute($this->attribute_rental_id))->getAttribute();
        if ( !$attribute) {
            return false;
        }

        $attribute_value = $this->getAttributeValue($this->slug, $attribute->attribute_name);
        if ( !$attribute_value) {
            return false;
        }

        $attribute_value->deleted = wp_delete_term($attribute_value->term_id, "pa_$attribute->attribute_name");

        return $attribute_value;
    }
}