## Features

<div class="doc-feature-container">
  <div class="doc-feature"><div><img src='includes/compressed/rangepicker.png' /></div><div><b>Date Time Range Picker</b><p>It's a range picker, with time!</p></div></div>
  <div class="doc-feature"><div><img src='includes/compressed/predefined.png' /></div><div><b>Predefined Ranges</b><p>You can use default ranges, or define your own!</p></div></div>
  <div class="doc-feature"><div><img src='includes/compressed/singledate.png' /></div><div><b>Single Date Time Selection Support</b><p>It can also be used as a single date time picker!</p></div></div>
  <div class="doc-feature"><div><img src='includes/compressed/customizable.png' /></div><div><b>Customizable</b><p>You can modify all the picker's behaviour like hiding some part, disabling some feature etc.</p></div></div>
  <div class="doc-feature"><div><img src='includes/compressed/quickswitch.png' /></div><div><b>Quick Switching</b><p>Supports fast month and year navigation!</p></div></div>
  <div class="doc-feature"><div><img src='includes/compressed/inline.png' /></div><div><b>Inline Support</b><p>If you don't like dropdowns, you can convert your input to an inline calendar!</p></div></div>
  <div class="doc-feature"><div><img src='includes/compressed/mobileready.png' /></div><div><b>Mobile Ready</b><p>It renders beautifully on mobile devices</p></div></div>
  <div class="doc-feature"><div><img src='includes/compressed/landscape.png' /></div><div><b>Portrait/Landscape Support</b><p>Also has a different landscape layout</p></div></div>
  <div class="doc-feature"><div><img src='includes/compressed/touch.png' /></div><div><b>Touch Slide Support</b><p>You can slide between months!</p></div></div>
  <div class="doc-feature"><div><img src='includes/compressed/languages.png' /></div><div><b>109 Languages</b><p>We support **them** all!<br>(What moment.js supports :P)</p></div></div>
  <div class="doc-feature"><div><img src="includes/compressed/sass.png"></div><div><b>Sass Support</b><p>You can re-design completely using SASS.</p></div></div>
  <div class="doc-feature"><div><img src="includes/icons/grunt.svg"></div><div><b>Grunt Tasks</b><p>Yes, it's the automation era.</p></div></div>
</div>
<div class='icon-attribution'>Icons (except Sass and Grunt logo) made by <a href="http://www.freepik.com" title="Freepik">Freepik</a> from <a href="https://www.flaticon.com/" title="Flaticon">www.flaticon.com</a> is licensed by <a href="http://creativecommons.org/licenses/by/3.0/" title="Creative Commons BY 3.0" target="_blank">CC 3.0 BY</a></div>

## How to use it

The main files of this plugin are `calentim.min.js` and `calentim.min.css`, which are generated by compiling and minifying `calentim.js` and `calentim.css`. The plugin relies on **jQuery** and **moment.js** libraries, also needs to be included before including `calentim.min.js`.

The font used on this plugin is **Roboto**, and the icons are provided by **Font Awesome** which are included remotely from their CDN's. You can change it anyway you want.

The example configuration which can be found in the base index file is:

```html
<link href="https://fonts.googleapis.com/css?family=Roboto:300,400,400i,500,700" rel="stylesheet"/>
<link href="http://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet"/>
<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/2.1.4/jquery.min.js"></script>
<script>window.jQuery || document.write('<script src="js/jquery-2.1.4.min.js" type="text/javascript"><\/script>');
</script>
<!-- .calentim includes -->
<link href="build/css/calentim.min.css" rel="stylesheet"/>
<script src="build/js/moment.min.js"></script>
<script src="build/js/calentim.min.js"></script>
<!-- .end calentim includes -->
```

Then, to attach a Calentim object to an element you desire, use this:

```javascript
$(".calentim").calentim();
```

You can customize your plugin with options you provide to the initializing function,
```javascript
$(".calentim").calentim({inline: true, startOnMonday: true});
```
or the element's `data-plugin-options` property.
```html
<input class="calentim" data-plugin-options='{"calendarCount":1,"showHeader":true,"showFooter":true}'
name="calendar-input" type="text" value="08.08.2017 12:43 - 08.09.2017 13:11"/>
```

Once initalized, you can access the calentim object like this:
```javascript
var calentim = $(".calentim:eq(3)").data("calentim");
calentim.config.startDate = new Date();
calentim.reDrawCalendars();
```

## Properties

Once you've got the `calentim` instance object, you can access these properties:

- `elem` [DOM node object]: The HTML dom node which the instance is created on.
- `$elem` [jQuery Object]: jQuery object of the dom node. Equals to `$(calentim.elem)`

<br><br>
> Please **Note** that if you've chosen a different target element, **you will be accessing the initiator element** by calling `calentim.$elem`. Your actual target element would be `calentim.config.target`.
<br><br>
For example,

```javascript
	var calentim = $("#elem1").calentim();
	// calentim.elem will be equal to document.getElementById("elem1") or $("#elem1").get(0);
	// calentim.$elem will be equal to $("#elem1");
```

<br><br>
- `config` [JS Object]: The instance's configuration object. Consists of merging default values and user defined settings. The details of it is explained in the *Options* section.

<br><br>
These properties are also defined, but not recommended to tinker on.

- `container` [jQuery Object]: This refers to the outermost container element of the instance dropdown or inline instance and the input itself.
- `header` [jQuery Object]: This refers to the header part of the plugin.
- `footer` [jQuery Object]: This refers to the footer part, - not the mobile buttons part - the ranges part of the plugin.
- `input` [jQuery Object]: This refers to the first child of the container, which contains everything except the input which is calentim instantiated on.

## Configuration

These are the options you can set with the javascript plugin initialization object, or with the `data-plugin-options` html attribute on the input element, or within the events by directly modifying the `calentim.config` object.
<br><br>
- `startDate` [moment object|javascript Date Object|string]: the selected start date, initially today is selected if not defined inside the input's value, or any of the initialization configuration methods.
<br><br>
- `endDate` [moment object|javascript Date Object|string]: the selected end date, initially today is selected if not defined inside the input's value, or any of the initialization configuration methods.
<br><br>
- `format` [string]: the default format for showing in input, defaults to short date format of locale, for all possible inputs, look here: https://momentjs.com/docs/#/displaying/format/ default: 'L LT'
<br><br>
- `hourFormat` [number]: the format for the time pickers. Can be 12 or 24, if set anything else, will revert to default 24. default '24'

    **Note**: Be careful when setting this option, you might need to pick a suitable format for the `format` variable too. For example, you might set 12 hour calendar with **L HH:mm** format, and then receive 24 hour data on your backend.
<br><br>
- `dontPrefixHours` [boolean]: If the 12 hour format is selected, you can set this to true to get one digit hours without the "0" prefix. Default: false
<br><br>
- `minuteSteps` [number]: the minute steps you want to show on your minute picker, for example, if you set 15 as the step, you'll get 0, 15, 30 and 45 in your minute picker. Default: `1`
<br><br>
- `dateSeparator` [string]: if not used as a single date picker, this will be the seperator, default **" - "**.
<br><br>
- `calendarCount` [integer]: how many calendars will be shown in the plugin screen, default 2
<br><br>
- `inline` [boolean]: display as an inline input replacement instead of input dropdown. default: false
<br><br>
- `minDate` [moment object|javascript Date Object|string|null]: minimum selectable date, default null (no minimum)
<br><br>
- `maxDate` [moment object|javascript Date Object|string|null]: maximum selectable date, default null (no maximum)
<br><br>
- `showHeader` [boolean]: visibility of the part which displays the selected start and end dates, default true
<br><br>
- `showFooter` [boolean]: visibility of the part which contains user defined ranges, default true
<br><br>
- `showButtons` [boolean]: whether the input should display the apply and cancel buttons in dropdown, default false
<br><br>
- `startEmpty` [boolean]: whether the input should remain empty until user makes a selection, default false
<br><br>
- `hideOutOfRange` [boolean]: when used with minDate and/or maxDate, the navigation arrows will be hidden on the available first and last months to prevent further navigation. default false
<br><br>
- `enableKeyboard` [boolean]: enable this if you want to add keyboard support to the calendar. The keys are:
  - <kbd>UP</kbd>              : Go to same weekday on the previous week
  - <kbd>DOWN</kbd>            : Go to same weekday on the next week
  - <kbd>LEFT</kbd>            : Go to the previous day
  - <kbd>RIGHT</kbd>           : Go to the next day
  - <kbd>PG UP</kbd>           : Go to the previous month
  - <kbd>PG DOWN</kbd>         : Go to the next month
  - <kbd>SHIFT + PG UP</kbd>   : Go to the previous year
  - <kbd>SHIFT + PG DOWN</kbd> : Go to the next year
<br><br>
- `startOnMonday` [boolean]: false, // if you want to start the calendars on Monday, set this to true. Note that if the locale already starts on Monday, this setting will be ignored.
<br><br>
- `container` [string]: the selector of the dropdowns container, default "body"
<br><br>
- `oneCalendarWidth` [integer]: the width of one calendar, if two calendars are shown, the input width will be 2 * this setting. default 230
<br><br>
- `showOn` ["bottom"|"top"|"left"|"right"|"center"]: dropdown placement position relative to input element, will be adjusted to the viewport, default "bottom"
<br><br>
- `arrowOn` ["bottom"|"top"|"left"|"right"|"center"]: arrow position relative to dropdown element, will be adjusted to the viewport, default "left"
<br><br>
- `autoAlign` [boolean]: enables dropdown auto placement change when the dropdown is not fully visible on the viewport. Default "true"
<br><br>
- `locale` [string]: moment locale setting, for more information: https://momentjs.com/docs/#/i18n/changing-locale/, and for a list of available locales: https://momentjs.com/ (bottom of the page)
<br><br>
- `singleDate` [boolean]: if you want a single date picker, set this to true, default false
<br><br>
- `target`: [jquery object] the element to update after selection, if it's null, the element that is instantiated on will be updated. default null
<br><br>
- `ranges`: [array] predefined ranges range objects array, which each will create a button in the footer, and when the user clicks, it'll automatically will be applied. One range is defined like below:

   - `title` [string]: the label which will appear on the button,
   - `startDate` [moment object|javascript Date Object|string]: the first date of the range,
   - `endDate` [moment object|javascript Date Object|string]: the last date of the range,
<br><br>
- `rangeLabel` [string] : The title displayed in the defined ranges list section, default "Ranges: "
<br><br>
- `cancelLabel` [string]: The cancel button label, default "Cancel"
<br><br>
- `applyLabel` [string]: The apply button label,  default "Apply"
<br><br>
- `enableMonthSwitcher` [boolean]: Enables the month switcher when clicking on month names. Default: true
<br><br>
- `monthSwitcherFormat` [boolean]: Changes the month name display format on the month switcher. Default: "MMMM"
<br><br>
- `enableYearSwitcher` [boolean]: Enables the year switcher when clicking on years. Default: true
<br><br>
- `numericMonthSwitcher` [boolean]: If set to true, shows month numbers instead of month names in month selector. Default: false
<br><br>
- `monthSwitcherFormat` [string]: Changes the format of the month name displayed on the month selector. Default: "MMMM" (long month name format)
<br><br>
- `showWeekNumbers` [string]: Shows week numbers on the left of the calendars. Default: false
<br><br>
- `autoCloseOnSelect` [boolean]: On instances that are not displayed inline, this setting is used to automatically close the dropdown when a selection is made.
<br><br>
- `disableDays` [function]: Enables day based disabling filters, input value is the current day to be processed. Example:
  ```javascript
  {
    disableDays: function(day){
       return day.isSame(moment("17/05/2017")); // will return true on that day and the day will be disabled.
    }
  }
  ```
<br><br>
- `disabledRanges` [object array]: Enables user to disable specific ranges from selection. Can be used with `continuous` option to preserve continuity. Object structure:
  ```javascript
   [{ start: [moment object], end: [moment object]}, ..]
  ```
<br><br>
- `continuous` [boolean]: Adds a check if the selected range continues any disabled days. Reverts the selection to it's original state when the user tries to select a range which contains a disabled date.
<br><br>
- `limitTimeForDay` [function]: Limits the time selection based on the day parameter, input value is the current day to be processed. Example:
  ```javascript
  {
      limitTimeForDay: function (day) {
          if (day.isoWeekday() === 6 || day.isoWeekday() === 7) {
              return { start: { hour: 8, minute: 15, ampm: null }, end: { hour: 18, minute: 21, ampm: null } };
          } else {
              return { start: { hour: 9, minute: 30, ampm: null }, end: { hour: 16, minute: 45, ampm: null } };
          }
      }
  }
  ```
  This limits the time selection to 8:15 and 18:21 if the day is on weekends, if it's not, it limits the selection to 9:30 to 16:45. You can see a working example in the examples section.
<br><br>
- `rangeOrientation` [string]: Sets the range view to "vertical" or "horizontal" which renders the range part on the right or on the bottom of the calendar. Default: "horizontal"
<br><br>
- `verticalRangeWidth` [string]: Sets the vertical range view panel width in pixels. Default: 150


## Available Events

- `onbeforeselect` [function]: event which is triggered before selecting the end date ( a range selection is completed). The return value decides whether the selection will happen. Returning *false* will prevent the input to update.

	**Prototype:**
	```javascript
		onbeforeselect: function(calentim, startDate, endDate){
			// calentim: calentim object instance
			// startDate: moment.js instance
			// endDate: moment.js instance
			return true; // false prevents update
		}
	```
<br><br>
- `onafterselect` [function]:  event which is triggered after selecting the end date ( the input value changed )

    **Prototype:**
	```javascript
		onafterselect: function(calentim, startDate, endDate){
			// calentim: calentim object instance
			// startDate: moment.js instance
			// endDate: moment.js instance
		}
	```
<br><br>
- `onbeforeshow` [function]:  event which is triggered before showing the dropdown

    **Prototype:**
	```javascript
		onbeforeshow: function(calentim){
			// calentim: calentim object instance
		}
	```
<br><br>
- `onbeforehide` [function]:  event which is triggered before hiding the dropdown

    **Prototype:**
	```javascript
		onbeforehide: function(calentim){
			// calentim: calentim object instance
		}
	```
<br><br>
- `onaftershow` [function]:  event which is triggered after showing the dropdown

    **Prototype:**
	```javascript
		onaftershow: function(calentim){
			// calentim: calentim object instance
		}
	```
<br><br>
- `onafterhide` [function]:  event which is triggered after hiding the dropdown

    **Prototype:**
	```javascript
		onafterhide: function(calentim){
			// calentim: calentim object instance
		}
	```
<br><br>
- `onfirstselect` [function]:  event which is triggered after selecting the first date of ranges

    **Prototype:**
	```javascript
		onfirstselect: function(calentim, startDate){
			// calentim: calentim object instance
			// startDate: moment.js instance
		}
	```
<br><br>
- `onrangeselect` [function]:  event which is triggered after selecting a range from the defined range links

    **Prototype:**
	```javascript
		onrangeselect: function(calentim, range){
			// calentim: calentim object instance
			// range: selected range definition
		}
	```
<br><br>
- `onbeforemonthchange` [function]:  event which fires before changing the first calendar month of multiple calendars, or the month of a single calendar. The return value decides whether the month switch will take place.

    **Prototype:**
	```javascript
		onbeforemonthchange: function(calentim, month, direction){
			// calentim: calentim object instance
			// month : moment.js object of first day of the month selected on the **first** calendar
            // direction: "next" or "prev", shows the month change direction. if `month.month()` is 4,
            // and direction is "prev", next month will be 3.
			return true; // false disables switching
		}
	```
<br><br>
- `onaftermonthchange` [function]:  event which fires after changing the first calendar month of multiple calendars, or the month of a single calendar

    **Prototype:**
	```javascript
		onaftermonthchange: function(calentim, month){
			// calentim: calentim object instance
			// month : moment.js object of first day of the month selected on the first calendar
		}
	```
<br><br>
- `onafteryearchange` [function]:  event which fires after changing the first calendar year of multiple calendars, or the year of a single calendar

    **Prototype:**
	```javascript
		onafteryearchange: function(calentim, year){
			// calentim: calentim object instance
			// year : moment.js object of first day of the year selected on the first calendar
		}
	```
- `ondraw` [function]:  event which fires after redraws in calendar

    **Prototype:**
  ```javascript
    onredraw: function(calentim){
      // calentim: calentim object instance
    }
  ```
<br><br>
- `oninit` [function]:  event which fires after instance initialization

    **Prototype:**
  ```javascript
    oninit: function(calentim){
      // calentim: calentim object instance
    }
  ```
<br><br>
- `onBeforeInit` [function]:  event which fires before instance initialization

    **Prototype:**
  ```javascript
    onBeforeInit: function(calentim){
      // calentim: calentim object instance
    }
  ```
<br><br>
- `ondestroy` [function]:  event which fires after instance destruction

    **Prototype:**
  ```javascript
    ondestroy: function(calentim){
      // calentim: calentim object instance
    }
  ```
<br><br>
- `onBeforeDestroy` [function]:  event which fires before instance destruction, if you return `false` to this functino, it cancels the destruction.

    **Prototype:**
  ```javascript
    onBeforeDestroy: function(calentim){
      // calentim: calentim object instance
      return true;
    }
  ```
<br><br>
- `ontimechange` [function]:  event which fires after timepicker value changes

    **Prototype:**
  ```javascript
    ontimechange: function(calentim, startDate, endDate){
      // calentim: calentim object instance
      // startDate: the start date moment object
      // endDate: the end date moment object
    }
  ```
<br><br>

## Methods

- `validateDates` [function]: Validates the *startDate*, *endDate*, *minDate*, *maxDate* parameters of the instance configuration, by the means of **parsability** and **order**, and defaults to today's date for *startDate* and *endDate*, and to null for *maxDate* and *minDate*.

- `fetchInputs` [function]: Retrieves the date(s) from the instance holder input and validates them before putting it to it's configuration.

- `updateInput` [function]: Updates the instance holder input with the instance values and configuration.

- `drawNextMonth` [function]: Triggers the instance show the next month after the first calendar month as the first calendar.

- `drawPrevMonth` [function]: Triggers the instance show the previous month before the first calendar month as the first calendar.

- `reDrawCalendars` [function]: Triggers a complete restructuring of the instance. Drawing the container first, then the header, then the calendars, then the footer.

- `reDrawCells` [function]: Only modifies the calendar's related parts with the configuration variables. Doesn't entirely build the instance again like `reDrawCalendars` method does.

- `setViewport` [function]: On dropdown instances, if the dropdown falls outside of the viewport (when shown, not scrolled) this function decides and calculates it's new position opposed to its configuration. For example, if the dropdown position is set to `bottom` and it falls below the page bottom edge, this method makes it appear as it was set to `top` for once.

- `showDropdown` [function]: On dropdown and mobile instances, if the dropdown is not visible, this method triggers the show method.

- `hideDropdown` [function]: On dropdown and mobile instances, if the dropdown is visible, this method hides it.

- `setStart` [function]: Sets the start date and time of the input.

- `setEnd`  [function]: Sets the end date and time of the input.

- `setMinDate` [function]: Sets the minimum selectable date of the input. Time portion is ignored.

- `setMaxDate` [function]: Sets the maximum selectable date of the input. Time portion is ignored.

- `setDisplayDate` [function] : Sets the displayed month and year, day and time are ignored.

```javascript
     var instance = $(".calentim").data("calentim");

     // using moment object
     instance.setStart(moment());

     // using javascript Date object
     instance.setStart(new Date());

     // using ISO and RFC standardized date strings
     instance.setStart("2017-11-27T13:07:04+00:00"); // ISO 8601 and RFC 3339
     instance.setStart("Mon, 27 Nov 2017 13:07:04 +0000"); // RFC 822, 1035, 1123, 2822
     instance.setStart("Monday, 27-Nov-17 13:07:04 UTC"); // RFC 2822

     // using unix timestamp
     instance.setStart(1511788024);

     // using custom formatted date time string
     instance.setStart(moment("16:06 27.11.2017","HH:mm dd.MM.YYYY"));

```

## Examples

<div id='examples-toc'></div>

### Default Range Picker
---
Preview:

<div class="well well-sm">
<input type="text" id="calentim-ex-1" />
</div>
<script type="text/javascript">$("#calentim-ex-1").calentim();</script>

  HTML:
  ```html
  	<input type="text" id="calentim-ex-1" />
  ```

  JavaScript:
  ```javascript
  	<script type="text/javascript">
  		$("#calentim-ex-1").calentim();
  	</script>
  ```

### Dropdown Positioning (Auto Alignment Enabled)
---
Preview:

<div class="well well-sm">
<input type="text" id="calentim-ex-1-1" />
<input type="text" id="calentim-ex-1-2" />
<input type="text" id="calentim-ex-1-3" />
<input type="text" id="calentim-ex-1-4" />
</div>
<script type="text/javascript">
$("#calentim-ex-1-1").calentim({showOn:"top",autoAlign:true});
$("#calentim-ex-1-2").calentim({showOn:"left",autoAlign:true});
$("#calentim-ex-1-3").calentim({showOn:"right",autoAlign:true});
$("#calentim-ex-1-4").calentim({showOn:"bottom",autoAlign:true});</script>

  HTML:
  ```html
  	<input type="text" id="calentim-ex-1-1" />
    <input type="text" id="calentim-ex-1-2" />
    <input type="text" id="calentim-ex-1-3" />
    <input type="text" id="calentim-ex-1-4" />
  ```

  JavaScript:
  ```javascript
  	<script type="text/javascript">
  		$("#calentim-ex-1-1").calentim({showOn:"top",autoAlign:true});
          $("#calentim-ex-1-2").calentim({showOn:"left",autoAlign:true});
          $("#calentim-ex-1-3").calentim({showOn:"right",autoAlign:true});
          $("#calentim-ex-1-4").calentim({showOn:"bottom",autoAlign:true});
  	</script>
  ```

### Dropdown Positioning (Auto Alignment Disabled)
---
Preview:

<div class="well well-sm">
<input type="text" id="calentim-ex-1-5" />
<input type="text" id="calentim-ex-1-6" />
<input type="text" id="calentim-ex-1-7" />
<input type="text" id="calentim-ex-1-8" />
</div>
<script type="text/javascript">
$("#calentim-ex-1-5").calentim({showOn:"top",autoAlign:false});
$("#calentim-ex-1-6").calentim({showOn:"left",autoAlign:false});
$("#calentim-ex-1-7").calentim({showOn:"right",autoAlign:false});
$("#calentim-ex-1-8").calentim({showOn:"bottom",autoAlign:false});</script>

  HTML:
  ```html
  	<input type="text" id="calentim-ex-1-5" />
    <input type="text" id="calentim-ex-1-6" />
    <input type="text" id="calentim-ex-1-7" />
    <input type="text" id="calentim-ex-1-8" />
  ```

  JavaScript:
  ```javascript
  	<script type="text/javascript">
  		$("#calentim-ex-1-5").calentim({showOn:"top",autoAlign:false});
          $("#calentim-ex-1-6").calentim({showOn:"left",autoAlign:false});
          $("#calentim-ex-1-7").calentim({showOn:"right",autoAlign:false});
          $("#calentim-ex-1-8").calentim({showOn:"bottom",autoAlign:false});
  	</script>
  ```

### Arrow Positioning
---
Preview:
<div class="well well-sm"><input type="text" class="vhide"><input type="text" id="calentim-ex-t-r" value="06/21/2017" /><input type="text" id="calentim-ex-t-c" value="06/21/2017" /><input type="text" id="calentim-ex-t-l" value="06/21/2017" /><input type="text" class="vhide"><br><br><input type="text" id="calentim-ex-l-t" value="06/21/2017" /><input type="text" class="vhide"><input type="text" class="vhide"><input type="text" class="vhide"><input type="text" id="calentim-ex-r-t" value="06/21/2017" /><br><br><input type="text" id="calentim-ex-l-c" value="06/21/2017" /><input type="text" class="vhide"><input type="text" id="calentim-ex-c-c" value="06/21/2017" /><input type="text" class="vhide"><input type="text" id="calentim-ex-r-c" value="06/21/2017" /><br><br><input type="text" id="calentim-ex-l-b" value="06/21/2017" /><input type="text" class="vhide"><input type="text" class="vhide"><input type="text" class="vhide"><input type="text" id="calentim-ex-r-b" value="06/21/2017" /><br><br><input type="text" class="vhide"><input type="text" id="calentim-ex-b-r" value="06/21/2017" /><input type="text" id="calentim-ex-b-c" value="06/21/2017" /><input type="text" id="calentim-ex-b-l" value="06/21/2017" /><input type="text" class="vhide"><br><br>
</div>
<script type="text/javascript">
$("#calentim-ex-t-r").calentim({ showOn: "top", arrowOn: "right" }); $("#calentim-ex-t-c").calentim({ showOn: "top", arrowOn: "center" }); $("#calentim-ex-t-l").calentim({ showOn: "top", arrowOn: "left" }); $("#calentim-ex-l-c").calentim({ showOn: "left", arrowOn: "center" }); $("#calentim-ex-l-t").calentim({ showOn: "left", arrowOn: "top" }); $("#calentim-ex-l-b").calentim({ showOn: "left", arrowOn: "bottom" }); $("#calentim-ex-c-c").calentim({ showOn: "center", arrowOn: "center" }); $("#calentim-ex-r-c").calentim({ showOn: "right", arrowOn: "center" }); $("#calentim-ex-r-t").calentim({ showOn: "right", arrowOn: "top" }); $("#calentim-ex-r-b").calentim({ showOn: "right", arrowOn: "bottom" }); $("#calentim-ex-b-r").calentim({ showOn: "bottom", arrowOn: "right" }); $("#calentim-ex-b-c").calentim({ showOn: "bottom", arrowOn: "center" }); $("#calentim-ex-b-l").calentim({ showOn: "bottom", arrowOn: "left" });
</script>

  HTML:
  ```html
    <style> .vhide{ visibility:hidden; } </style>
    <input type="text" class="vhide"><input type="text" id="calentim-ex-t-r" value="06/21/2017" /><input type="text" id="calentim-ex-t-c" value="06/21/2017" /><input type="text" id="calentim-ex-t-l" value="06/21/2017" /><input type="text" class="vhide"><br><br>
    <input type="text" id="calentim-ex-l-t" value="06/21/2017" /><input type="text" class="vhide"><input type="text" class="vhide"><input type="text" class="vhide"><input type="text" id="calentim-ex-r-t" value="06/21/2017" /><br><br>
    <input type="text" id="calentim-ex-l-c" value="06/21/2017" /><input type="text" class="vhide"><input type="text" id="calentim-ex-c-c" value="06/21/2017" /><input type="text" class="vhide"><input type="text" id="calentim-ex-r-c" value="06/21/2017" /><br><br>
    <input type="text" id="calentim-ex-l-b" value="06/21/2017" /><input type="text" class="vhide"><input type="text" class="vhide"><input type="text" class="vhide"><input type="text" id="calentim-ex-r-b" value="06/21/2017" /><br><br>
    <input type="text" class="vhide"><input type="text" id="calentim-ex-b-r" value="06/21/2017" /><input type="text" id="calentim-ex-b-c" value="06/21/2017" /><input type="text" id="calentim-ex-b-l" value="06/21/2017" /><input type="text" class="vhide"><br><br>
  ```

  JavaScript:
  ```javascript
  <script type="text/javascript">
    $("#calentim-ex-t-r").calentim({
        showOn: "top",
        arrowOn: "right"
    });
    $("#calentim-ex-t-c").calentim({
        showOn: "top",
        arrowOn: "center"
    });
    $("#calentim-ex-t-l").calentim({
        showOn: "top",
        arrowOn: "left"
    });
    $("#calentim-ex-l-c").calentim({
        showOn: "left",
        arrowOn: "center"
    });
    $("#calentim-ex-l-t").calentim({
        showOn: "left",
        arrowOn: "top"
    });
    $("#calentim-ex-l-b").calentim({
        showOn: "left",
        arrowOn: "bottom"
    });
    $("#calentim-ex-c-c").calentim({
        showOn: "center",
        arrowOn: "center"
    });
    $("#calentim-ex-r-c").calentim({
        showOn: "right",
        arrowOn: "center"
    });
    $("#calentim-ex-r-t").calentim({
        showOn: "right",
        arrowOn: "top"
    });
    $("#calentim-ex-r-b").calentim({
        showOn: "right",
        arrowOn: "bottom"
    });

    $("#calentim-ex-b-r").calentim({
        showOn: "bottom",
        arrowOn: "right"
    });
    $("#calentim-ex-b-c").calentim({
        showOn: "bottom",
        arrowOn: "center"
    });
    $("#calentim-ex-b-l").calentim({
        showOn: "bottom",
        arrowOn: "left"
    });
  </script>
  ```

### Hiding the header
---
Preview:

<div class="well well-sm">
<input type="text" id="calentim-ex-2" />
</div>
<script type="text/javascript">$("#calentim-ex-2").calentim({showHeader: false});</script>

  HTML:
  ```html
  	<input type="text" id="calentim-ex-2" />
  ```

  JavaScript:
  ```javascript
  	<script type="text/javascript">
  		$("#calentim-ex-2").calentim({showHeader: false});
  	</script>
  ```

### Hiding the footer
---
Preview:

<div class="well well-sm">
<input type="text" id="calentim-ex-3" />
</div>
<script type="text/javascript">$("#calentim-ex-3").calentim({showFooter: false});</script>

  HTML:
  ```html
  	<input type="text" id="calentim-ex-3" />
  ```

  JavaScript:
  ```javascript
  	<script type="text/javascript">
  		$("#calentim-ex-3").calentim({showFooter: false});
  	</script>
  ```

### Hiding calendars
---
Preview:

<div class="well well-sm">
<input type="text" id="calentim-ex-3-3" />
</div>
<script type="text/javascript">$("#calentim-ex-3-3").calentim({showCalendars: false, format: "hh:mm A"});</script>

  HTML:
  ```html
  	<input type="text" id="calentim-ex-3-3" />
  ```

  JavaScript:
  ```javascript
  	<script type="text/javascript">
  		$("#calentim-ex-3-3").calentim({
        showCalendars: false,
        format: "hh:mm A"
      });
  	</script>
  ```

### Hiding time pickers
---
Preview:

<div class="well well-sm">
<input type="text" id="calentim-ex-3-4" />
</div>
<script type="text/javascript">$("#calentim-ex-3-4").calentim({showTimePickers: false, format: "L"});</script>

  HTML:
  ```html
  	<input type="text" id="calentim-ex-3-4" />
  ```

  JavaScript:
  ```javascript
  	<script type="text/javascript">
  		$("#calentim-ex-3-4").calentim({showTimePickers: false, format: "L"});
  	</script>
  ```

### Empty on initialization
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-5-1" placeholder="Select a Date" />
</div>
<script type="text/javascript">$("#calentim-ex-5-1").calentim({startEmpty: true});</script>

  HTML:
  ```html
  	<input type="text" id="calentim-ex-5-1" placeholder="Select a Date" />
  ```

  JavaScript:
  ```javascript
  	<script type="text/javascript">
  		$("#calentim-ex-5-1").calentim({startEmpty: true});
  	</script>
  ```

### Showing dropdown apply/cancel buttons
---
This will only work with dropdown desktop view, inline views don't support cancel and apply buttons. Mobile modal view already has them.
<br>
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-5-3" placeholder="Select a Date" />
</div>
<script type="text/javascript">$("#calentim-ex-5-3").calentim({showButtons: true});</script>

  HTML:
  ```html
  	<input type="text" id="calentim-ex-5-3" placeholder="Select a Date" />
  ```

  JavaScript:
  ```javascript
  	<script type="text/javascript">
  		$("#calentim-ex-5-1").calentim({showButtons: true});
  	</script>
  ```
### Changing hour format
---
Preview:

<div class="well well-sm">
<input type="text" id="calentim-ex-3-1" />
</div>
<script type="text/javascript">$("#calentim-ex-3-1").calentim({format: "DD/MM/YYYY HH:mm", hourFormat: 24});</script>

  HTML:
  ```html
    <input type="text" id="calentim-ex-3-1" />
  ```

  JavaScript:
  ```javascript
    <script type="text/javascript">
      $("#calentim-ex-3-1").calentim({
        format: "DD/MM/YYYY HH:mm",
        hourFormat: 24
      });
    </script>
  ```

### Changing minute steps
---
Preview:

<div class="well well-sm">
<input type="text" id="calentim-ex-3-2" />
</div>
<script type="text/javascript">$("#calentim-ex-3-2").calentim({minuteSteps: 15});</script>

  HTML:
  ```html
    <input type="text" id="calentim-ex-3-2" />
  ```

  JavaScript:
  ```javascript
    <script type="text/javascript">
      $("#calentim-ex-3-2").calentim({
        minuteSteps: 15
      });
    </script>
  ```

### Changing Timepicker arrow directions
---
Preview:

<div class="well well-sm">
<input type="text" id="calentim-ex-3-5" />
</div>
<script type="text/javascript">$("#calentim-ex-3-5").calentim({reverseTimepickerArrows: true});</script>

  HTML:
  ```html
    <input type="text" id="calentim-ex-3-5" />
  ```

  JavaScript:
  ```javascript
    <script type="text/javascript">
      $("#calentim-ex-3-5").calentim({
        reverseTimepickerArrows: true
      });
    </script>
  ```


### Changing calendar count
---
Preview:

<div class="well well-sm">
<input type="text" id="calentim-ex-4" />
</div>
<script type="text/javascript">$("#calentim-ex-4").calentim({calendarCount: 3});</script>

  HTML:
  ```html
  	<input type="text" id="calentim-ex-4" />
  ```

  JavaScript:
  ```javascript
  	<script type="text/javascript">
  		$("#calentim-ex-4").calentim({calendarCount: 3});
  	</script>
  ```

### Inline calendar
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-5" />
</div>
<script type="text/javascript">$("#calentim-ex-5").calentim({inline: true});</script>

  HTML:
  ```html
  	<input type="text" id="calentim-ex-5" />
  ```

  JavaScript:
  ```javascript
  	<script type="text/javascript">
  		$("#calentim-ex-5").calentim({inline: true});
  	</script>
  ```

### Inline time picker
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-5-2" />
</div>
<script type="text/javascript">$("#calentim-ex-5-2").calentim({
  inline: true,
  showCalendars: false,
  format: "hh:mm A"
});</script>

  HTML:
  ```html
  	<input type="text" id="calentim-ex-5-2" />
  ```

  JavaScript:
  ```javascript
  	<script type="text/javascript">
  		$("#calentim-ex-5-2").calentim({
            inline: true,
            showCalendars: false,
            format: "hh:mm A"
          });
  	</script>
  ```

### Single date time picker
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-6" />
</div>
<script type="text/javascript">$("#calentim-ex-6").calentim({singleDate: true});</script>

  HTML:
  ```html
  	<input type="text" id="calentim-ex-6" />
  ```

  JavaScript:
  ```javascript
  	<script type="text/javascript">
  		$("#calentim-ex-6").calentim({singleDate: true});
  	</script>
  ```

### Range/Single switch
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<label for='single-calentim-mod'><input type='radio' value="single"  id='single-calentim-mod' name="calentim-type-selector" class='calentim-type-selector'>&nbsp;Single Date</label>
<label for='multi-calentim-mod'><input type='radio' value="multi"  id='multi-calentim-mod' name="calentim-type-selector" class='calentim-type-selector' checked>&nbsp;Multiple Dates</label>
<input type="text" id="calentim-ex-6-4" />
</div>
<script type="text/javascript">
  $("#calentim-ex-6-4").calentim();
  $(".calentim-type-selector").click(function(){
    $("#calentim-ex-6-4").data("calentim").container.remove();
    $("#calentim-ex-6-4").calentim({
      singleDate: $("input[name='calentim-type-selector']:checked").val() == "single" ? true : false
    });
  });
</script>

  HTML:
  ```html
<label for='single-calentim-mod'>
  <input type='radio' value="single"  id='single-calentim-mod' name="calentim-type-selector"
    class='calentim-type-selector'>
    &nbsp;Single Date
  </label>
<label for='multi-calentim-mod'>
  <input type='radio' value="multi"  id='multi-calentim-mod' name="calentim-type-selector"
    class='calentim-type-selector' checked>
  &nbsp;Multiple Dates
</label>
    <input type="text" id="calentim-ex-6-4" />
  ```

  JavaScript:
  ```javascript
  <script type="text/javascript">
  $("#calentim-ex-6-4").calentim();
  $(".calentim-type-selector").click(function(){
    $("#calentim-ex-6-4").data("calentim").destroy();
    $("#calentim-ex-6-4").calentim({
      singleDate: $("input[name='calentim-type-selector']:checked").val() == "single" ? true : false
    });
  });
  </script>
  ```

### Linked Single Date Pickers
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<div style='display: flex;'>
  <div>Start Date: <input type="text" id="calentim-ex-6-5-start" /></div>
  <div style='margin-left:20px;'>End Date:  <input type="text" id="calentim-ex-6-5-end" /></div>
</div>
</div>
<script type="text/javascript">
    var startDate, endDate, startInstance, endInstance;
    var fillInputs = function () {
        if (startDate) startInstance.$elem.val(startDate.locale(startInstance.config.locale).format(startInstance.config.format));
        if (endDate) endInstance.$elem.val(endDate.locale(endInstance.config.locale).format(endInstance.config.format));
    };
    var beforeShow = function (instance) {
        if (startDate) {
            startInstance.config.startDate = startDate.clone();
            endInstance.config.startDate = startDate.clone();
        }
        if (endDate) {
            startInstance.config.endDate = endDate.clone();
            endInstance.config.endDate = endDate.clone();
        }
        fillInputs();
        instance.updateHeader();
        instance.reDrawCells();
        instance.updateTimePickerDisplay();
    };
    $("#calentim-ex-6-5-start").calentim({
        startEmpty: $("#calentim-ex-6-5-start").val() === "",
        startDate: $("#calentim-ex-6-5-start").val(),
        endDate: $("#calentim-ex-6-5-end").val(),
        enableKeyboard: false,
        oninit: function (instance) {
            startInstance = instance;
            if (!instance.config.startEmpty && instance.config.startDate) {
                instance.$elem.val(instance.config.startDate.locale(instance.config.locale).format(instance.config.format));
                startDate = instance.config.startDate.clone();
            }
        },
        onaftershow: beforeShow,
        ontimechange: function (instance, start, end) {
            if(start) startDate = start.clone();
            if(end) endDate = end.clone();
            fillInputs();
        },
        onfirstselect: function (instance, start) {
            startDate = start.clone();
            endDate = null;
            startInstance.globals.startSelected = false;
            startInstance.hideDropdown();
            endInstance.showDropdown();
            endInstance.setDisplayDate(start.clone());
            endInstance.config.minDate = startDate.clone();
            endInstance.config.startDate = startDate.clone();
            endInstance.config.endDate = null;
            endInstance.globals.startSelected = true;
            endInstance.globals.endSelected = false;
            endInstance.globals.firstValueSelected = true;
            if (endDate && startDate.isAfter(endDate)) {
                endInstance.config.endDate = endDate.clone();
            }
            fillInputs();
            endInstance.updateHeader();
            endInstance.reDrawCells();
            endInstance.updateTimePickerDisplay();
        }
    });
    $("#calentim-ex-6-5-end").calentim({
        startEmpty: $("#calentim-ex-6-5-end").val() === "",
        startDate: $("#calentim-ex-6-5-start").val(),
        endDate: $("#calentim-ex-6-5-end").val(),
        enableKeyboard: false,
        autoCloseOnSelect: true,
        oninit: function (instance) {
            endInstance = instance;
            if (!instance.config.startEmpty && instance.config.endDate) {
                instance.$elem.val(instance.config.endDate.locale(instance.config.locale).format(instance.config.format));
                endDate = instance.config.endDate.clone();
            }
        },
        onaftershow: beforeShow,
        ontimechange: function (instance, start, end) {
            if(start) startDate = start.clone();
            if(end) endDate = end.clone();
            fillInputs();
        },
        onafterselect: function (instance, start, end) {
            startDate = start.clone();
            endDate = end.clone();
            endInstance.hideDropdown();
            startInstance.config.endDate = endDate.clone();
            startInstance.globals.firstValueSelected = true;
            fillInputs();
            endInstance.globals.startSelected = true;
            endInstance.globals.endSelected = false;
        }
    });
</script>

  HTML:
  ```html
  <div style='display: flex;'>
    <div>Start Date: <input type="text" id="calentim-ex-6-5-start" /></div>
    <div style='margin-left:20px;'>End Date:  <input type="text" id="calentim-ex-6-5-end" /></div>
  </div>
  ```

  JavaScript:
  ```javascript
  <script type="text/javascript">
    var startDate, endDate, startInstance, endInstance;
    var fillInputs = function () {
        if (startDate) startInstance.$elem.val(startDate.locale(startInstance.config.locale).format(startInstance.config.format));
        if (endDate) endInstance.$elem.val(endDate.locale(endInstance.config.locale).format(endInstance.config.format));
    };
    var beforeShow = function (instance) {
        if (startDate) {
            startInstance.config.startDate = startDate.clone();
            endInstance.config.startDate = startDate.clone();
        }
        if (endDate) {
            startInstance.config.endDate = endDate.clone();
            endInstance.config.endDate = endDate.clone();
        }
        fillInputs();
        instance.updateHeader();
        instance.reDrawCells();
        instance.updateTimePickerDisplay();
    };
    $("#calentim-ex-6-5-start").calentim({
        startEmpty: $("#calentim-ex-6-5-start").val() === "",
        startDate: $("#calentim-ex-6-5-start").val(),
        endDate: $("#calentim-ex-6-5-end").val(),
        enableKeyboard: false,
        oninit: function (instance) {
            startInstance = instance;
            if (!instance.config.startEmpty && instance.config.startDate) {
                instance.$elem.val(instance.config.startDate.locale(instance.config.locale).format(instance.config.format));
                startDate = instance.config.startDate.clone();
            }
        },
        onaftershow: beforeShow,
        ontimechange: function (instance, start, end) {
            if(start) startDate = start.clone();
            if(end) endDate = end.clone();
            fillInputs();
        },
        onfirstselect: function (instance, start) {
            startDate = start.clone();
            endDate = null;
            startInstance.globals.startSelected = false;
            startInstance.hideDropdown();
            endInstance.showDropdown();
            endInstance.setDisplayDate(start.clone());
            endInstance.config.minDate = startDate.clone();
            endInstance.config.startDate = startDate.clone();
            endInstance.config.endDate = null;
            endInstance.globals.startSelected = true;
            endInstance.globals.endSelected = false;
            endInstance.globals.firstValueSelected = true;
            if (endDate && startDate.isAfter(endDate)) {
                endInstance.config.endDate = endDate.clone();
            }
            fillInputs();
            endInstance.updateHeader();
            endInstance.reDrawCells();
            endInstance.updateTimePickerDisplay();
        }
    });
    $("#calentim-ex-6-5-end").calentim({
        startEmpty: $("#calentim-ex-6-5-end").val() === "",
        startDate: $("#calentim-ex-6-5-start").val(),
        endDate: $("#calentim-ex-6-5-end").val(),
        enableKeyboard: false,
        autoCloseOnSelect: true,
        oninit: function (instance) {
            endInstance = instance;
            if (!instance.config.startEmpty && instance.config.endDate) {
                instance.$elem.val(instance.config.endDate.locale(instance.config.locale).format(instance.config.format));
                endDate = instance.config.endDate.clone();
            }
        },
        onaftershow: beforeShow,
        ontimechange: function (instance, start, end) {
            if(start) startDate = start.clone();
            if(end) endDate = end.clone();
            fillInputs();
        },
        onafterselect: function (instance, start, end) {
            startDate = start.clone();
            endDate = end.clone();
            endInstance.hideDropdown();
            startInstance.config.endDate = endDate.clone();
            startInstance.globals.firstValueSelected = true;
            fillInputs();
            endInstance.globals.startSelected = true;
            endInstance.globals.endSelected = false;
        }
    });
</script>
  ```

### Minimal Single date time picker
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-6-2" />
</div>
<script type="text/javascript">$("#calentim-ex-6-2").calentim({singleDate: true, calendarCount: 1, showHeader: false, showFooter: false,autoCloseOnSelect: true});</script>

  HTML:
  ```html
    <input type="text" id="calentim-ex-6-2" />
  ```

  JavaScript:
  ```javascript
    <script type="text/javascript">
      $("#calentim-ex-6-2").calentim({
        singleDate: true,
        calendarCount: 1,
        showHeader: false,
        showFooter: false,
        autoCloseOnSelect: true
      });
    </script>
  ```


### Limiting time based on day
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-6-7" />
</div>
<script type="text/javascript">$("#calentim-ex-6-7").calentim({
    limitTimeForDay: function (day) {
        if (day.isoWeekday() === 6 || day.isoWeekday() === 7) {
            return { start: { hour: 8, minute: 15, ampm: null }, end: { hour: 18, minute: 21, ampm: null } };
        } else {
            return { start: { hour: 9, minute: 30, ampm: null }, end: { hour: 16, minute: 45, ampm: null } };
        }
    }
});</script>

  HTML:
  ```html
    <input type="text" id="calentim-ex-6-7" />
  ```

  JavaScript:
  ```javascript
    <script type="text/javascript">
      $("#calentim-ex-6-7").calentim({
        limitTimeForDay: function (day) {
          if (day.isoWeekday() === 6 || day.isoWeekday() === 7) {
            return { start: { hour: 8, minute: 15, ampm: null }, end: { hour: 18, minute: 21, ampm: null } };
          } else {
            return { start: { hour: 9, minute: 30, ampm: null }, end: { hour: 16, minute: 45, ampm: null } };
          }
        }
      });
    </script>
  ```


### Limiting time based on day (12-h formatted)
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-6-7-1" />
</div>
<script type="text/javascript">$("#calentim-ex-6-7-1").calentim({
    limitTimeForDay: function (day) {
        if (day.isoWeekday() === 6 || day.isoWeekday() === 7) {
            return { start: { hour: 8, minute: 15, ampm: "am" }, end: { hour: 6, minute: 21, ampm: "pm" } };
        } else {
            return { start: { hour: 9, minute: 30, ampm: "am" }, end: { hour: 4, minute: 45, ampm: "pm" } };
        }
    }
});</script>

  HTML:
  ```html
    <input type="text" id="calentim-ex-6-7-1" />
  ```

  JavaScript:
  ```javascript
    <script type="text/javascript">
      $("#calentim-ex-6-7-1").calentim({
        limitTimeForDay: function (day) {
          if (day.isoWeekday() === 6 || day.isoWeekday() === 7) {
            return { start: { hour: 8, minute: 15, ampm: "am" }, end: { hour: 6, minute: 21, ampm: "pm" } };
          } else {
            return { start: { hour: 9, minute: 30, ampm: "pm" }, end: { hour: 4, minute: 45, ampm: "pm" } };
          }
        }
      });
    </script>
  ```


### Limiting time based on day (multiple time ranges)
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-6-7-2" />
</div>
<script type="text/javascript">$("#calentim-ex-6-7-2").calentim({
    hourFormat: 24,
    limitTimeForDay: function (day) {
      if (day.isoWeekday() === 6 || day.isoWeekday() === 7) {
        return { start: { hour: 9, minute: 0, ampm: null }, end: { hour: 12, minute: 30, ampm: null } };
      } else {
        return [
          { start: { hour: 9, minute: 0, ampm: null }, end: { hour: 12, minute: 30, ampm: null } },
          { start: { hour: 13, minute: 30, ampm: null }, end: { hour: 18, minute: 00, ampm: null } }
        ];
      }
    }
});</script>

  HTML:
  ```html
    <input type="text" id="calentim-ex-6-7-2" />
  ```

  JavaScript:
  ```javascript
    <script type="text/javascript">
      $("#calentim-ex-6-7-2").calentim({
        hourFormat: 24,
        limitTimeForDay: function (day) {
          if (day.isoWeekday() === 6 || day.isoWeekday() === 7) {
            return { start: { hour: 9, minute: 0, ampm: null }, end: { hour: 12, minute: 30, ampm: null } };
          } else {
            return [
              { start: { hour: 9, minute: 0, ampm: null }, end: { hour: 12, minute: 30, ampm: null } },
              { start: { hour: 13, minute: 30, ampm: null }, end: { hour: 18, minute: 00, ampm: null } }
            ];
          }
        }
      });
    </script>
  ```



### Ranges on the Right
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-6-6-1" />
</div>
<script type="text/javascript">$("#calentim-ex-6-6-1").calentim({rangeOrientation: "vertical"});</script>

  HTML:
  ```html
    <input type="text" id="calentim-ex-6-6-1" />
  ```

  JavaScript:
  ```javascript
    <script type="text/javascript">
      $("#calentim-ex-6-6-1").calentim({
        rangeOrientation: "vertical"
      });
    </script>
  ```

### Ranges on the Right with Buttons
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-6-6-2" />
</div>
<script type="text/javascript">$("#calentim-ex-6-6-2").calentim({rangeOrientation: "vertical", showButtons: true});</script>

  HTML:
  ```html
    <input type="text" id="calentim-ex-6-6-2" />
  ```

  JavaScript:
  ```javascript
    <script type="text/javascript">
      $("#calentim-ex-6-6-2").calentim({
        rangeOrientation: "vertical",
        showButtons: true
      });
    </script>
  ```
### Ranges on the Right (inline)
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-6-6-3" />
</div>
<script type="text/javascript">$("#calentim-ex-6-6-3").calentim({inline: true, rangeOrientation: "vertical"});</script>

  HTML:
  ```html
    <input type="text" id="calentim-ex-6-6-3" />
  ```

  JavaScript:
  ```javascript
    <script type="text/javascript">
      $("#calentim-ex-6-6-3").calentim({
        inline: true,
        rangeOrientation: "vertical"
      });
    </script>
  ```
### Showing week numbers
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-6-6-4" />
</div>
<script type="text/javascript">$("#calentim-ex-6-6-4").calentim({showWeekNumbers: true});</script>

  HTML:
  ```html
    <input type="text" id="calentim-ex-6-6-4" />
  ```

  JavaScript:
  ```javascript
    <script type="text/javascript">
      $("#calentim-ex-6-6-4").calentim({
        showWeekNumbers: true
      });
    </script>
  ```

### Auto Close on Select
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-6-1" />
</div>
<script type="text/javascript">$("#calentim-ex-6-1").calentim({autoCloseOnSelect: true});</script>

  HTML:
  ```html
  <input type="text" id="calentim-ex-6-1" />
  ```

  JavaScript:
  ```javascript
  <script type="text/javascript">
    $("#calentim-ex-6-1").calentim({autoCloseOnSelect: true});
  </script>
  ```

### Defining Min/Max Dates
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-6-3" />
</div>
<script type="text/javascript">$("#calentim-ex-6-3").calentim({
  minDate: moment().subtract(1, "weeks").startOf("week"),
  maxDate: moment().add(1, "weeks").endOf("week")
});</script>

  HTML:
  ```html
  <input type="text" id="calentim-ex-6-3" />
  ```

  JavaScript:
  ```javascript
  <script type="text/javascript">
    $("#calentim-ex-6-3").calentim({
      minDate: moment().subtract(1, "weeks").startOf("week"),
      maxDate: moment().add(1, "weeks").endOf("week")
    });
  </script>
  ```

### Defining custom ranges
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-7" />
</div>
<script type="text/javascript">$("#calentim-ex-7").calentim({ranges: [
{
title: "Next Week",
startDate: moment().add(1,"weeks").startOf("week"),
endDate: moment().add(1,"weeks").endOf("week")
},
{
title: "Today",
startDate: moment(),
endDate: moment()
},
{
title: "Yesterday",
startDate: moment().subtract(1,"days"),
endDate: moment().subtract(1,"days")
},
{
title: "Last 7 days",
startDate: moment().subtract(7,"days"),
endDate: moment().subtract(1,"days")
},
{
title: "Last 30 days",
startDate: moment().subtract(30,"days"),
endDate: moment().subtract(1,"days")
},
{
title: "This month",
startDate: moment().startOf("month"),
endDate: moment().endOf("month")
},
{
title: "Last month",
startDate: moment().subtract(1,"months").startOf("month"),
endDate: moment().subtract(1,"months").endOf("month")
}
]});</script>

  HTML:
  ```html
  	<input type="text" id="calentim-ex-7" />
  ```

  JavaScript:
  ```javascript
  	<script type="text/javascript">
  		$("#calentim-ex-7").calentim({ranges: [
  			{
  				title: "Next Week",
  				startDate: moment().add(1,"weeks").startOf("week"),
  				endDate: moment().add(1,"weeks").endOf("week")
  			},
  			{
  				title: "Today",
  				startDate: moment(),
  				endDate: moment()
  			},
  			{
  				title: "Yesterday",
  				startDate: moment().subtract(1,"days"),
  				endDate: moment().subtract(1,"days")
  			},
  			{
  				title: "Last 7 days",
  				startDate: moment().subtract(7,"days"),
  				endDate: moment().subtract(1,"days")
  			},
  			{
  				title: "Last 30 days",
  				startDate: moment().subtract(30,"days"),
  				endDate: moment().subtract(1,"days")
  			},
  			{
  				title: "This month",
  				startDate: moment().startOf("month"),
  				endDate: moment().endOf("month")
  			},
  			{
  				title: "Last month",
  				startDate: moment().subtract(1,"months").startOf("month"),
  				endDate: moment().subtract(1,"months").endOf("month")
  			}
  		]});
  	</script>
  ```

### Custom events
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-8" />
<div class="calentimlabel"></div>
</div>
<script type="text/javascript">$("#calentim-ex-8").calentim({
onafterselect: function(calentim, startDate, endDate) {
calentim.$elem.closest(".well").find(".calentimlabel").text("You have chosen between " + startDate.format('LLLL') + " and " + endDate.format('LLLL'));
}
});</script>

  HTML:
  ```html
  	<input type="text" id="calentim-ex-8" />
  	<div class="calentimlabel"></div>
  ```

  JavaScript:
  ```javascript
  	<script type="text/javascript">
  		$("#calentim-ex-8").calentim({
  			onafterselect: function(calentim, startDate, endDate) {
 				calentim.$elem.closest(".well").find(".calentimlabel")
				.text("You have chosen between " + startDate.format('LLLL') + " and " + endDate.format('LLLL'));
  			}
  		});
  	</script>
  ```

### Hotel Booking System

---

Preview:

<div class="well well-sm" style="overflow: auto;"><input type="text" id="calentim-ex-9-1" /></div>
<script type="text/javascript">$("#calentim-ex-9-1").calentim({isHotelBooking: true, disabledRanges: [{start: moment(), end: moment().add(2, "days")}], continuous: true, minSelectedDays: 1, startEmpty: true});</script>

HTML:

```html
<input type="text" id="calentim-ex-9-1" />
```

JavaScript:

```javascript
	<script type="text/javascript">
		$("#calentim-ex-9-1").calentim({
      isHotelBooking: true,
      continuous: true,
      startEmpty: true,
      minSelectedDays: 1,
      disabledRanges: [
        {
          start: moment(),
          end: moment().add(2, "days")
        }
      ]
    });
	</script>
```

### Change first day of week
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-9" />
</div>
<script type="text/javascript">$("#calentim-ex-9").calentim({startOnMonday: true});</script>

  HTML:
  ```html
  	<input type="text" id="calentim-ex-9" />
  ```

  JavaScript:
  ```javascript
  	<script type="text/javascript">
  		$("#calentim-ex-9").calentim({startOnMonday: true});
  	</script>
  ```

### Changing locale
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-10" />
</div>
<script type="text/javascript">var userLanguage = navigator.language || navigator.userLanguage;if(userLanguage == "en") userLanguage = "fr";$("#calentim-ex-10").calentim({locale: userLanguage });</script>

  HTML:
  ```html
  	<input type="text" id="calentim-ex-10" />
  ```

  JavaScript:
  ```javascript
  	<script type="text/javascript">
  		var userLanguage = navigator.language || navigator.userLanguage;
  		if(userLanguage == "en") userLanguage = "fr";
  		$("#calentim-ex-10").calentim({locale: userLanguage });
  	</script>
  ```

### Changing locale (inline)
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-10-2" />
</div>
<script type="text/javascript">var userLanguage = navigator.language || navigator.userLanguage;if(userLanguage == "en") userLanguage = "fr";$("#calentim-ex-10-2").calentim({locale: userLanguage, inline: true });</script>

  HTML:
  ```html
      <input type="text" id="calentim-ex-10-2" />
  ```

  JavaScript:
  ```javascript
      <script type="text/javascript">
          var userLanguage = navigator.language || navigator.userLanguage;
          if(userLanguage == "en") userLanguage = "fr";
          $("#calentim-ex-10-2").calentim({locale: userLanguage, inline: true });
      </script>
  ```


### Changing locale (non-latin)
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-10-3" />
</div>
<script type="text/javascript">$("#calentim-ex-10-3").calentim({locale: "ar", inline: true });</script>

  HTML:
  ```html
      <input type="text" id="calentim-ex-10-3" />
  ```

  JavaScript:
  ```javascript
      <script type="text/javascript">
          $("#calentim-ex-10-3").calentim({locale: "ar", inline: true });
      </script>
  ```


### RTL Support
---
Preview:
<div class="well well-sm" dir="rtl" style="overflow: auto;">
<input type="text" id="calentim-ex-10-4" />
</div>
<script type="text/javascript">$("#calentim-ex-10-4").calentim({locale: "ar", isRTL: true, arrowOn: "right" });</script>

  HTML:
  ```html
      <div dir="rtl">
        <input type="text" id="calentim-ex-10-4" />
      </div>
  ```

  JavaScript:
  ```javascript
      <script type="text/javascript">
          $("#calentim-ex-10-4").calentim({locale: "ar", isRTL: true, arrowOn: "right" });
      </script>
  ```

### Week Select Mode
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-10-1" />
</div>
<script type="text/javascript">$("#calentim-ex-10-1").calentim({
        onfirstselect: function(elem,start){
            elem.config.startDate = moment(start).startOf("week");
            elem.config.endDate = moment(start).endOf("week");
            elem.globals.endSelected = true;
            elem.globals.startSelected = false;
            elem.globals.hoverDate = null;
            elem.input.find( ".calentim-apply" ).removeAttr( "disabled" );
            elem.updateInput();
        }
      });</script>

  HTML:
  ```html
    <input type="text" id="calentim-ex-10-1" />
  ```

  JavaScript:
  ```javascript
    <script type="text/javascript">
      $("#calentim-ex-10").calentim({
        onfirstselect: function(elem,start){
            elem.config.startDate = moment(start).startOf("week");
            elem.config.endDate = moment(start).endOf("week");
            elem.globals.endSelected = true;
            elem.globals.startSelected = false;
            elem.globals.hoverDate = null;
            elem.container.find( ".calentim-apply" ).removeAttr( "disabled" );
            elem.updateInput();
        }
      });
    </script>
  ```

### Custom target element
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-11-target" />
<button id="calentim-ex-11">Open calentim</button>
</div>
<script type="text/javascript">$("#calentim-ex-11").calentim({target: $("#calentim-ex-11-target")});</script>

  HTML:
  ```html
    <input type="text" id="calentim-ex-11-target" />
	<button id="calentim-ex-11">Open calentim</button>
  ```

  JavaScript:
  ```javascript
  	<script type="text/javascript">
  		$("#calentim-ex-11").calentim({target: $("#calentim-ex-11-target")});
  	</script>
  ```

### Custom disabled ranges (with callback)
---
**Note:** This task would only fill the input on Wednesdays, because the only valid (selectable) dates are Wednesdays on the calendar. If the start day or end day isn't selectable, the plugin will revert itself to `startEmpty` state when initialized.
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-13" />
</div>
<script type="text/javascript">$("#calentim-ex-13").calentim({disableDays: function(day){return day.day() == 3 ? false : true}});</script>

  HTML:
  ```html
    <input type="text" id="calentim-ex-13" />
  ```

  JavaScript:
  ```javascript
    <script type="text/javascript">
      $("#calentim-ex-13").calentim({
        disableDays: function(day){
          return day.day() != 3;
        }
      });
    </script>
  ```

### Custom disabled ranges (with array)
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-13-2" value="03/19/2017 12:00 AM - 03/20/2017 12:00 AM" />
</div>
<script type="text/javascript">$("#calentim-ex-13-2").calentim({
  disabledRanges: [
    {
      "start": moment("10/03/2017","DD/MM/YYYY"),
      "end": moment("18/03/2017", "DD/MM/YYYY")
    },
    {
      "start": moment("01/04/2017","DD/MM/YYYY"),
      "end": moment("05/04/2017", "DD/MM/YYYY")
    },
    {
      "start": moment("11/04/2017","DD/MM/YYYY"),
      "end": moment("15/04/2017", "DD/MM/YYYY")
    }
  ]
});</script>

  HTML:
  ```html
    <input type="text" id="calentim-ex-13-2" value="03/19/2017 12:00 AM - 03/20/2017 12:00 AM" />
  ```

  JavaScript:
  ```javascript
    <script type="text/javascript">
      $("#calentim-ex-13-2").calentim({
        disabledRanges: [
          {
            "start": moment("10/03/2017","DD/MM/YYYY"),
            "end": moment("18/03/2017", "DD/MM/YYYY")
          },
          {
            "start": moment("01/04/2017","DD/MM/YYYY"),
            "end": moment("05/04/2017", "DD/MM/YYYY")
          },
          {
            "start": moment("11/04/2017","DD/MM/YYYY"),
            "end": moment("15/04/2017", "DD/MM/YYYY")
          }
        ]
      });
    </script>
  ```

### Custom disabled ranges (preserve continuousity)
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<input type="text" id="calentim-ex-13-3" value="03/19/2017 12:00 AM - 03/20/2017 12:00 AM" />
</div>
<script type="text/javascript">$("#calentim-ex-13-3").calentim({
  continuous: true,
  disabledRanges: [
    {
      start: moment("10/03/2017","DD/MM/YYYY"),
      end: moment("18/03/2017", "DD/MM/YYYY")
    },
    {
      "start": moment("01/04/2017","DD/MM/YYYY"),
      "end": moment("05/04/2017", "DD/MM/YYYY")
    },
    {
      "start": moment("11/04/2017","DD/MM/YYYY"),
      "end": moment("15/04/2017", "DD/MM/YYYY")
    }
  ]
});</script>

  HTML:
  ```html
    <input type="text" id="calentim-ex-13-3" value="03/19/2017 12:00 AM - 03/20/2017 12:00 AM" />
  ```

  JavaScript:
  ```javascript
    <script type="text/javascript">
      $("#calentim-ex-13-3").calentim({
        continuous: true,
        disabledRanges: [
          {
            start: moment("10/03/2017","DD/MM/YYYY"),
            end: moment("18/03/2017", "DD/MM/YYYY")
          },
          {
            "start": moment("01/04/2017","DD/MM/YYYY"),
            "end": moment("05/04/2017", "DD/MM/YYYY")
          },
          {
            "start": moment("11/04/2017","DD/MM/YYYY"),
            "end": moment("15/04/2017", "DD/MM/YYYY")
          }
        ]
      });
    </script>
  ```

### Disable only start dates

---

Preview:

<div class="well well-sm" style="overflow: auto;"><input type="text" id="calentim-ex-13-5" value="03/19/2017 - 03/20/2017" /></div>
<script type="text/javascript">$("#calentim-ex-13-5").calentim({
  disableOnlyStart: true,
  disabledRanges: [
    {
      start: moment("10/03/2017","DD/MM/YYYY"),
      end: moment("18/03/2017", "DD/MM/YYYY")
    },
    {
      "start": moment("01/04/2017","DD/MM/YYYY"),
      "end": moment("05/04/2017", "DD/MM/YYYY")
    },
    {
      "start": moment("11/04/2017","DD/MM/YYYY"),
      "end": moment("15/04/2017", "DD/MM/YYYY")
    }
  ]
});</script>

HTML:

```html
<input type="text" id="calentim-ex-13-5" value="03/19/2017 - 03/20/2017" />
```

JavaScript:

```javascript
  <script type="text/javascript">
    $("#calentim-ex-13-5").calentim({
      disableOnlyStart: true,
      disabledRanges: [
        {
          "start": moment("10/03/2017","DD/MM/YYYY"),
          "end": moment("18/03/2017", "DD/MM/YYYY")
        },
        {
          "start": moment("01/04/2017","DD/MM/YYYY"),
          "end": moment("05/04/2017", "DD/MM/YYYY")
        },
        {
          "start": moment("11/04/2017","DD/MM/YYYY"),
          "end": moment("15/04/2017", "DD/MM/YYYY")
        }
      ]
    });
  </script>
```


### Disable only end dates

---

Preview:

<div class="well well-sm" style="overflow: auto;"><input type="text" id="calentim-ex-13-6" value="03/19/2017 - 03/20/2017" /></div>
<script type="text/javascript">$("#calentim-ex-13-6").calentim({
  disableOnlyEnd: true,
  disabledRanges: [
    {
      start: moment("10/03/2017","DD/MM/YYYY"),
      end: moment("18/03/2017", "DD/MM/YYYY")
    },
    {
      "start": moment("01/04/2017","DD/MM/YYYY"),
      "end": moment("05/04/2017", "DD/MM/YYYY")
    },
    {
      "start": moment("11/04/2017","DD/MM/YYYY"),
      "end": moment("15/04/2017", "DD/MM/YYYY")
    }
  ]
});</script>

HTML:

```html
<input type="text" id="calentim-ex-13-6" value="03/19/2017 - 03/20/2017" />
```

JavaScript:

```javascript
  <script type="text/javascript">
    $("#calentim-ex-13-6").calentim({
      disableOnlyEnd: true,
      disabledRanges: [
        {
          "start": moment("10/03/2017","DD/MM/YYYY"),
          "end": moment("18/03/2017", "DD/MM/YYYY")
        },
        {
          "start": moment("01/04/2017","DD/MM/YYYY"),
          "end": moment("05/04/2017", "DD/MM/YYYY")
        },
        {
          "start": moment("11/04/2017","DD/MM/YYYY"),
          "end": moment("15/04/2017", "DD/MM/YYYY")
        }
      ]
    });
  </script>
```

### Show & Hide with triggers
---
Preview:
<div class="well well-sm" style="overflow: auto;"><input type="text" id="calentim-ex-13-1" /><button class="calentim-show">Show Instance</button><button class="calentim-hide">Hide Instance</button></div>
<script type="text/javascript">$("#calentim-ex-13-1").calentim();
$(".calentim-show").on("click",function(e){var calentim = $("#calentim-ex-13-1").data("calentim");calentim.showDropdown(e);});
$(".calentim-hide").on("click",function(e){var calentim = $("#calentim-ex-13-1").data("calentim");calentim.hideDropdown(e);});
</script>

  HTML:
  ```html
    <input type="text" id="calentim-ex-13-1" />
    <button class="calentim-show">Show Instance</button>
    <button class="calentim-hide">Hide Instance</button>
  ```

  JavaScript:
  ```javascript
    <script type="text/javascript">
      $("#calentim-ex-13-1").calentim();
      $(".calentim-show").on("click",function(e){
        var calentim = $("#calentim-ex-13-1").data("calentim");
        calentim.showDropdown(e);
      });
      $(".calentim-hide").on("click",function(e){
        var calentim = $("#calentim-ex-13-1").data("calentim");
        calentim.hideDropdown(e);
      });
    </script>
  ```

### Using inside a modal
---
Preview:
<div class="well well-sm" style="overflow: auto;">
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
<div class="modal-dialog" role="document">
<div class="modal-content">
<div class="modal-body">
<input type="text" id="calentim-ex-12" />
</div>
<div class="modal-footer">
<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
</div>
</div>
</div>
</div>
<!-- Button trigger modal -->
<button type="button" class="btn btn-primary" onclick="$('#myModal').modal('show');" >
Launch demo modal
</button>
</div>
<script type="text/javascript">$("#calentim-ex-12").calentim();</script>

  HTML:
  ```html
	<!-- Modal -->
	<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
	  <div class="modal-dialog" role="document">
	    <div class="modal-content">
	      <div class="modal-body">
	        <input type="text" id="calentim-ex-12" />
	      </div>
	      <div class="modal-footer">
	        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
	      </div>
	    </div>
	  </div>
	</div>
	<!-- Button trigger modal -->
	<button type="button" class="btn btn-primary" onclick="$('#myModal').modal('show');" >
	  	Launch demo modal
	</button>
  ```

  JavaScript:
  ```javascript
  	<script type="text/javascript">
  		$("#calentim-ex-12").calentim();
  	</script>
  ```

## Themes

  There are 4 ready to use themes included in this package. You can include any theme by just switching the css file you've loaded inside your HTML file:

### Default theme (Current) <a href="single-test-inline.html" target="_blank">Demo</a>
  ```html
  <link href="build/css/calentim.min.css" rel="stylesheet"/>
  ```
  <img src='includes/compressed/theme-default.png' />

### Alternative theme <a href="single-test-alt.html" target="_blank">Demo</a>
  ```html
  <link href="build/css/calentim-alt.min.css" rel="stylesheet"/>
  ```
  <img src='includes/compressed/theme-alt.png' />


### Dark theme <a href="single-test-dark.html" target="_blank">Demo</a>
  ```html
  <link href="build/css/calentim-dark.min.css" rel="stylesheet"/>
  ```
  <img src='includes/compressed/theme-dark.png' />



### Dark Alternative theme <a href="single-test-dark-alt.html" target="_blank">Demo</a>
  ```html
  <link href="build/css/calentim-dark-alt.min.css" rel="stylesheet"/>
  ```
  <img src='includes/compressed/theme-dark-alt.png' />


### Creating your own theme

  You can create and use your theme by modifying and building any of the SCSS files included within the package `/css` folder. To add your own theme without touching the others, you need to copy 2 files and modify the Grunt configuration file.

  - First, create `calentim-variables-[your theme slug].scss` by copying any one of the `calentim-variables-*.scss` files, whichever is more close to your design.
  - Then create `calentim-[your theme slug].scss` by copying the `calentim.scss` file, and modify the first import to load your `calentim-variables-[your theme slug].scss` file.
  - Open `Gruntfile.js` at the root of the package, add
  ```javascript
  'build/css/calentim-[your theme name].min.css': 'css/calentim-[your theme name].scss'
  ```
  to the `sass.dist.files` array to get it built and minified, and add `build/css/calentim-[your-theme-name].min.css` file to the `postcss.files` array to get it enhanced to be crossbrowser compatible.

  After that, when you run `grunt min`, you'll get your `build/css/calentim-[your theme slug].min.css` file built and ready to use in your applications. When developing the theme, you can use `grunt watcher` to get a live reload server running and utilizing single-test.html file, you can live edit your theme variables. Just don't forget to update the linked stylesheet in the single test to your modified one.

## Important Notes

- I left the *calentim* object fully accessible to the inner variables, so you can alter the object's config in any event. For example, you can alter the max date of the calendar after first selection like this (limiting the user to select max 7 days of the first selection):

    ```javascript
    onfirstselect: function(calentim, startDate){
		calentim.config.maxDate = startDate.clone().add(7,"days");
	},
	onafterselect: function(calentim, startDate, endDate){
	    calentim.config.maxDate = null;
	}
    ```
    or another example, disabling previous date selection:
    ```javascript
    onfirstselect: function(calentim, startDate){
		calentim.config.minDate = startDate.clone();
	},
	onafterselect: function(calentim, startDate, endDate){
	    calentim.config.minDate = null;
	}
    ```

- The **cloning** is very important when *adding* or *subtracting*, because they modify the reference element too! As you can see in the above examples, the *startDate* and the *endDate* elements are cloned when defining the *maxDate* and *minDate* values. If you don't want to modify the *startDate* or *endDate* intentionally, use cloning.

- <strike>Mobile only supports modal like interface. Dropdowns and inline options currently don't work on mobile phones.</strike> Added inline support on mobile devices on version 1.1.2.

- Only one event can be bound using the initialize config object. Multiple events are not supported.

## Changelog

- #### v1.0.0
   - Released initial version.

- #### v1.0.1
   - fixed minute step overflow error on last step range
   - fixed ineffective initial value on `startEmpty: true` setting
   - fixed parameterless hideDropdown call bug in firefox
   - fixed multiple instance closing issues
   - added option to remove time picker
   - added infinite scroll on timepickers

- #### v1.0.2
	 - fixed target element confusion when different target option is specified
	 - added `showCalendars` option to disable date selection (only time picker)

- #### v1.1.0
   - fixed an issue about time pickers setting the wrong value on first click
   - fixed autoCloseOnSelect on singleDate version / mobile views
   - changed code to make clicking on disabled days select start/end date
   - added some transition delays to make it smoother
   - added keyboard navigation (`enableKeyboard` option)
        - up: previous week
        - down: next week
        - left: previous day
        - right: next day
        - space: select day
        - pageup: previous month
        - pagedown next month
        - shift + pageup: previous year
        - shift + pagedown: next year
   - added easy year switch buttons on year list
   - fixed startEmpty cell selected classes
   - added destroy method and some extra tests
   - fix custom target element reading in fetchInputs method

- #### v1.1.1
   - fixed the month change problem which is caused by a reset when validating dates.

- #### v1.1.2
   - fixed the problem about showing the initial month when the selected date is in a different month.
   - added inline view support on mobile devices
   - fixed startEmpty behaviour when clicking the cancel button on mobile

- #### v1.1.3
   - added showButtons property for not automatically updating the input, default false
   - added tests for showButtons property
   - added time changes to onbeforechange and onafterchange event
   - fixed range selection on instances with startEmpty: true defined
   - fixed hovering bug after month change when first date is selected

- #### v1.1.4
   - fixed button disabled state with startEmpty and showButtons are both active
   - reapplied deleted locale setting
   - innerWidth function was called on javascript object, not jQuery object, fixed.
   - buttons now don't submit forms.

- #### v1.1.5
   - configuration objects attached to prototype converted to independent objects
   - startEmpty property clears input on initialization
   - added jshint javascript linter to gruntfile
   - some optimizations
   - moved event bubbling in one method
   - added "left" "right" display options ("showOn" option, default "bottom")
   - added auto positioning enable/disable flag ("autoAlign" option, default "true")
   - added position recalculation on window scroll and resize events
   - fixed hour:minute scrolling issue
   - fixed css issue about month selector in small calendars
   - fixed locale error on month selector
   - added adjustment for font-size in month selector page

- #### v1.1.6
   - Repeating day issue caused by daylight saving time activation fixed.

- #### v1.1.7
   - fixed header display bug on startEmpty
   - converted moment instances to unix timestamps on reDrawCells method
   - added first and last hover classes (border radius effect)
   - removed autoprefixer and added postcss plugin for browser compatible CSS
   - fixed visibility issues
   - Added `calentim-not-in-month` class for the days that don't belong to that month
   - Replaced moment's `.startOf("day")` to `middleOfDay()` extension function to minimize DST change bugs.
   - switched from grunt-jasmine to karma test runner

- #### v1.1.8
   - added next day selection demo to linked single time pickers example
   - fixed ESC key hiding inline calendars bug.
   - added backup and restore time pickers method to keep time values intact on month changes

- #### v1.1.9
   - fixed display bug on header (start week of day showed day number instead of name)
   - improved linked single date picker example

- #### v1.2.0
   - updated jQuery library in demos and readme to v3.1.2
   - updated getDimensions method to more paint and memory friendly version
   - added setStart, setEnd, setMinDate, setMaxDate and setDisplayDate methods
   - added istanbul test code coverage tools
   - added start and end date validation regarding minimum and maximum allowed dates
   - added `reverseTimepickerArrows` option to reverse the actions of time picker arrows

- #### v1.2.1
   - changed prev and next hour/minute displays regarding to reverseTimePickerArrows setting.
   - fixed 12h display bug on showing dropdown in 24h format
   - fixed dropdown positioning on inner scrolling container other than window

- #### v1.2.2
   - fixed calendar header locale bug
   - fixed startOnMonday dismissing the 1st day row when its on sunday

- #### v1.2.3
   - added predefined events to hideDropdown and showDropdown to prevent var undefined exception.
   - updated example about linked date pickers
   - implemented ontimechange event
   - added month name format on monthselector
   - added week numbers on calendars

- #### v1.2.4
   - Added right side range list panel settings
   - Updated documentation
   - added smart positioning on top/bottom dropdowns
   - added selected range indicators
   - massive performance upgrade
   - added arrowOn parameter which moves the arrow to the desired position.
   - improved positioning on viewport edges
   - added center/center display option

- #### v1.2.5
   - added onaftermonthchange and onafteryearchange to month and year selectors
   - added calentim-disabled-range class on mindate/maxdate effective days
   - added day clones instead of real ones as attributes of events
   - fixed mobile button bug on month change
   - fixed autocloseonselect not updating input on mobile
   - fixed time up/down buttons

- #### v1.2.6
   - documentation fixes
   - removed firing onafterselect running after a time change
   - separated time picker update code to let start or end date update their designated inputs separately
   - added null controls to variables passed to events by cloning
   - updated linked single date pickers example on documentation
   - added onBeforeInit, onBeforeDestroy and ondestroy event
   - fixed mobile modal resizing height issue

- #### v1.2.7
   - added timepicker time limiting feature
   - updated documentation

- #### v1.2.8
   - added fix for IOS devices hover on first click feature/bug

- #### v1.2.9
   - fix for timepicker up/down buttons activating wrong instances

- #### v1.2.10
   - fix for timepicker hour up down buttons working with minuteSteps variable

- #### v1.2.11
   - fix range selection ignores time

- #### v1.2.12
   - new feature: hiding arrows before minDate and after maxDate
   - fix for timepicker update on range selections
   - css fix for Edge browser

- #### v1.2.13
   - some styling fixes about height change on inline calendar month switches

- #### v1.3.0
   - added hotel style booking feature for ranges
   - added disableOnlyStart and disableOnlyEnd parameters
   - selections not in month should have not-in-month class
   - added minSelectedDays parameter to prevent users to select less than defined days
   - added enableSwipe configuration parameter to enable/disable calendar swipe left/right to switch months, default enabled
   - added configurations for icons in the plugin
   - added auto close after range selection
   - added DOBCalendar option to act as a date-of-birth selector
   - added onCancel event to verify cancellation
   - fix for wrong week start regarding to locale on Safari

- #### v1.3.1
   - more localization on calendar numerals
   - added keyboard support for time pickers
   - added RTL support
   - fixed isDisabled method resetting the time to middle of the day

- #### v1.3.2
   - fixed hotel mode selection clear bug on dropdown open
   - fixed IE9 & Edge right side range display
   - added examples for disableOnlyStart and disableOnlyEnd options
   - added examples for hotel style booking feature

- #### v1.3.3
   - added "!default" for scss variables to enable overrides
   - fixed range continuity check preventing date selection in single date mode
   - added tests to package
   - added date checks and needed conversions on initialization
   - fixed single date selection on ranges

- #### v1.3.4
   - prevented timepicker to change the day when overflow occurs
   - fixed missing onCancel event handler
   - changed checkMobile method to only use media queries, not browser agent strings
   - added setting for mobile/desktop view threshold (mobileBreakpoint)
   - added calendar close feature on mobile backdrop click
   - fixed swipe month switch ignoring hideOutOfRange setting
   - fixed tests differing between mobile and desktop view

- #### v1.3.5
   - added support for multiple disabled time ranges
   - removed time change modifying dates
   - added example for multiple disabled time ranges

- #### v1.3.6
   - fix for timepickers only view resetting to today's date on dropdown show event
   - fix discontinuous selection mode when there are disabled ranges

- #### v1.3.7
   - fix uninitialized disable cache bug
   - fixed hideOutOfRange not affecting month and year selectors
   - fix displaying current year in year selector
   - improved theming support and created 3 themes besides the standard theme (dark, alt & dark-alt)
   - added `dontPrefixHours` variable to prevent 12-hour format hour padding with zero



## Copyright & Licenses
* *Calentim* Date/Time Range Picker<br>
   Copyright (c) Taha PAKSU <http://www.tahapaksu.com><br>
   All rights reserved.<br>

* Based on *jQuery — New Wave JavaScript* http://www.jquery.org<br>
   Copyright (c) JS Foundation and other contributors, https://js.foundation/<br>
   Released under [jQuery License](https://jquery.org/license/)<br>
   All rights reserved.<br>


* Based on *Moment.js* http://www.momentjs.com<br>
   Copyright (c) JS Foundation and other contributors<br>
   Moment.js is freely distributable under the terms of the [MIT license](https://github.com/moment/moment/blob/develop/LICENSE).<br>
   All rights reserved.<br>

* Includes *hammer.js* http://hammerjs.github.io<br>
   Copyright (C) 2011-2014 by Jorik Tangelder (Eight Media)<br>
   hammer.js is freely distributable under the terms of the [MIT license](https://github.com/hammerjs/hammer.js/blob/master/LICENSE.md).<br>
   All rights reserved.<br>
